function [ndata,ndata2,ndata3,ndata4,ndata5] = savpivots_1v3exs_nr(data,ori,termi,ch1,prepost1,dist,ch3,prepost3)
%This function is an automated way to extract the pivot list, rotated
%pivot list and pivot properties of a set of classified synapses.  Used to
%be called synpivots.  Pretty much same as savpivots, but this is
%specifically designed for use to compare two classes, meaning if you want
%to find exclusive VGluT1 synapses or VGluT2 synapses.  1v3 is modified so
%we are able to compare three classes, so 1 to 2 and 2 to 3, we will also
%save class 2 to make things more efficient in compuation.  This is
%prompted by the desire to compare VGluT1 and VGluT2 to VGluT1&2 synapses.
%s stands for punc_colo_s.  (NO Rotations, no alldata)
%Synatax:   [ndata] = savpivots_1v2(data,ori,termi,ch1,ch2);
%Input:     data = punc_data data structure used for the classification
%           alldata = all_data data structure from punc_locodist
%           ori = the origin or central pivot used for the analysis
%           termi = the termini for the analysis, really only used for the
%                   generation of the rotated pivots
%           dist = the distance between ch1 and ch3 that will be used to
%               create class 2
%           ch1 = the first third channel, e.g., VGlut1
%           prepost1 = the prepost parameter for punc_colo_all for ch1
%           ch2 = the second third channel, e.g., VGlut2&3
%           prepost2 = the prepost parameter for punc_colo_all for ch2&3
%           ch3 = the second third channel, e.g., VGlut2
%           prepost3 = the prepost parameter for punc_colo_all for ch2

%Output:    ndata = a structure with the fields, pivots, properties, and
%                   summary.  The layers of the structure match the layer
%                   structure of the data.  Note: filename is carried over
%                   from data.
%           ndata2 = ndata for the second set.
%           ndata3 = ndata for the third set.

filenames = data(1).filenames;  %pull out the channel names
pathnames12 = uigetdir3('','Directory for Unique 1st Dataset');       %get the directory where you want to save into.
pathnames21 = uigetdir3('','Directory for 1st overlapped with 3rd');       %get the directory where you want to save into.
pathnames32 = uigetdir3('','Directory for Unique 3rd Dataset');       %get the directory where you want to save into.
pathnames23 = uigetdir3('','Directory for 2nd overlapped with 3rd');       %get the directory where you want to save into.
pathnames2 = uigetdir3('','Directory for Unique 2nd dataset');       %get the directory where you want to save into.
tverts = data(ori).termi;   %grab the terminal vertices
tprops = data(ori).termi_prop;   %grab the terminal properties
tdist = data(ori).distance;     %grab the distance to termi

%first create the property index
pcache = tprops(:,:,1);     %example set
pcache(isnan(pcache(:,1)),:) = [];  %remove nan lines
pidx = sum(pcache(:,:));    %grab the first few point for a little test, we pick 5, because changes low that all 5 are not deci
idx_int = round(pidx);   %convert to integer, the size meteric should be the only integer in the lot
idx_tmp = pidx==idx_int;     %where is the int?
idx_tmp = idx_tmp+(median(pcache,1)<100);   %intensity measurements are huge
idx_tmp = idx_tmp+(pidx~=0);     %cannot be zero, size that is
pidx = find(idx_tmp==3);     %find it, meet all criteria, done
if size(pidx,2)>1    %the wild case where the two made it through
    pidx = 2;    %default only really works for me really
end
clear pcache

%lets generate the two classes and the indexes for the two classes.
%           idx = the index of the synaptic subset
%           idx2 = is the indext of the 2nd synaptic subset, i.e., VGluT2&2
%                   if idx is VGluT1.
%           idx3 = VGluT2
%NOTE!: By default here the thrid point is considered closer to the termi
%and is offset by 1, which you will need to change if you decide on
%something differ.
[class] = punc_colo_s(data,ori,ch1,'termi',termi,'mod',1,'mod_fltr',1,'pp_fltr',1,'prepost',prepost1); %class 1
idx = class(1).s_total_idx;
% [class] = punc_colo_s(data,ori,ch2,'termi',termi,'mod',1,'mod_fltr',1,'pp_fltr',1,'prepost',prepost2); %class 2
% idx2 = class(1).s_total_idx;
[class] = punc_colo_s(data,ori,ch3,'termi',termi,'mod',1,'mod_fltr',1,'pp_fltr',1,'prepost',prepost3); %class 3
idx3 = class(1).s_total_idx;
%[nd] = savpivots(data,alldata,ori,termi,idx2);  %test save out #2

%Lets find the unique vertices first
c1 = data(ori).vertices;        %grab the ori vertices for the first class(VGluT1)
c1(idx,:) = [];                 %The vertices for class 1
% c2 = data(ori).vertices;        %grab the ori vertices for the second class(VGluT1&2)
% c2(idx2,:) = [];                %the vertices for class 2
c3 = data(ori).vertices;        %grab the ori vertices for the second class(VGluT2)
c3(idx3,:) = [];                %the vertices for class 3

%compare 1 to 3
[a2b,b2a,ab,vsidx] = unique_verts2(c1,c3);   %find the unique vertices
clear a2b b2a ab
%now we are going to go through the shared vertices and place them with
%either 2 (13) or 1 or 3.
tri3 = data(ori).termi(:,:,ch3(1));    %grab the cooresponding third vertices
tri3(idx3,:) = [];   
tri1 = data(ori).termi(:,:,ch1(1));
tri1(idx,:) = [];   
tri1(vsidx{1},:) = [];      %isolate down to the ones that overlap
tri3(vsidx{2},:) = [];
d = dddist(tri1,tri3);      %calculate the distance between the two third points
%now filter by distance
tmpidx = find(d<=dist);     %temporary inclusion matrix
tmpidx2 = find(d>dist);     %temporary exclusion matrix
%lets create the unique index for class 2
uidx2 = [c1 linspace(1,size(c1,1),size(c1,1))'];         %grab the lot + new ordinals
uidx2(vsidx{1},:) = [];     %pare down to the shared
uidx2(tmpidx2,:) = [];      %now only class 2 vertices
uidx2 = uidx2(:,4);         %take the ordinals and done
uidx2f1 = vsidx{3}(tmpidx,:);   %class 2 from class 1, or the indexed location in class1 where the class 2 pivots come from
uidx2f3 = vsidx{4}(tmpidx,:);   %class 2 from class 3, or the indexed location in class3 where the class 2 pivots come from
%now sort back the other types based on distance from the origin
tprop1 = data(ori).termi_prop(:,:,ch1(1));       %grab the properties, which includes the distances
tprop1(idx,:) = [];
tprop3 = data(ori).termi_prop(:,:,ch3(1));
tprop3(idx3,:) = [];
tprop1 = [tprop1 linspace(1,size(tprop1,1),size(tprop1,1))'];    %tack on its own ordinal
tprop3 = [tprop3 linspace(1,size(tprop3,1),size(tprop3,1))'];    %tack on its own ordinal
tprop1(vsidx{1},:) = [];    %only the ones that overlap
tprop3(vsidx{2},:) = [];
tprop1(tmpidx,:) = 0;       %set to zero the verts that are part of class 2
tprop3(tmpidx,:) = 0;
%first find the distance position in the array, it should be oridnal -1, or
%the end of the original array
distpos = size(tprop1,2)-1;
%now compare the the two properties list
tmpidx3 = (tprop1(:,distpos)<tprop3(:,distpos));    %these vertices belong to class 1
tmp3 = tprop1(tmpidx3,:);  %ones belonging to class 1
uidx21 = tmp3(:,distpos+1);    %the oridinals, this will generate class1 list that is further from class3 than wanted list
uidx = vertcat(vsidx{1},uidx21);    %the ordinals + the unique indexs
%now vertices that belong to class3
tmpidx4 = (tprop1(:,distpos)>tprop3(:,distpos));    %these vertices belong to class 3
tmp4 = tprop3(tmpidx4,:);  %ones belonging to class 3
uidx23 = tmp4(:,distpos+1);    %the oridinals, this will generate class1 list that is further from class3 than wanted list
uidx3 = vertcat(vsidx{2},uidx23);    %the ordinals + the unique indexs

count = [];
count2 = [];
count3 = [];
count21 = [];
count23 = [];
h = waitbar(0,'Processing Properties of: ');    %initialize progress bar.
for i = 1:size(filenames,2)     %go through the channels
    %initiate
    sdata = [];
    sdata2 = [];
    sdata3 = [];
    sdata4 = [];
    sdata5 = [];
    %process filename
    strmask = isspace(filenames{i});
    spcloc = find(strmask==1);
    filename = strtrim(filenames{i}(min(spcloc):max(spcloc)));
    celllabels{i} = filename;  %create a cell array of file names to label the count files
    waitbar(i/size(filenames,2),h,['Processing Properties of: ' filename]);   %update progress
    if i==ori   %process for data at the origin
        %get self data (self=ori)
        %process for class 1(VGluT1)
        vert_tmp = data(ori).vertices;    %all ori vertices
        vert_tmp(idx,:) = [];             %all relavent vertices
        vert_tmp = vert_tmp(uidx,:);      %now unique
        c1 = vert_tmp;                    %store this for later use
        prop_tmp = flatview2(data(ori).vert_prop,'max');   %all of the ori properties
        prop_tmp = [prop_tmp zeros(size(prop_tmp,1),1)];    %append the distance
        prop_tmp(idx,:) = [];         %all of the relavent vertices
        prop_tmp = prop_tmp(uidx,:);    %now unique
        %process for class 2(VGluT21)
        vert_tmp2 = data(ori).vertices;    %all ori vertices
        vert_tmp2(idx,:) = [];             %all relavent vertices
        vert_tmp2 = vert_tmp2(uidx21,:);      %now unique
        d1 = vert_tmp2;                    %store this for later use
        prop_tmp2 = flatview2(data(ori).vert_prop,'max');   %all of the ori properties
        prop_tmp2 = [prop_tmp2 zeros(size(prop_tmp2,1),1)];    %append the distance
        prop_tmp2(idx,:) = [];         %all of the relavent vertices
        prop_tmp2 = prop_tmp2(uidx21,:);    %now unique
        %process for class 1(VGluT2)
        vert_tmp3 = data(ori).vertices;    %all ori vertices
        vert_tmp3(idx3,:) = [];             %all relavent vertices
        vert_tmp3 = vert_tmp3(uidx3,:);      %now unique
        c3 = vert_tmp3;                    %store this for later use
        prop_tmp3 = flatview2(data(ori).vert_prop,'max');   %all of the ori properties
        prop_tmp3 = [prop_tmp3 zeros(size(prop_tmp3,1),1)];    %append the distance
        prop_tmp3(idx3,:) = [];         %all of the relavent vertices
        prop_tmp3 = prop_tmp3(uidx3,:);    %now unique
        %process for class 2(VGluT32)
        vert_tmp4 = data(ori).vertices;    %all ori vertices
        vert_tmp4(idx3,:) = [];             %all relavent vertices
        vert_tmp4 = vert_tmp4(uidx23,:);      %now unique
        d3 = vert_tmp4;                    %store this for later use
        prop_tmp4 = flatview2(data(ori).vert_prop,'max');   %all of the ori properties
        prop_tmp4 = [prop_tmp4 zeros(size(prop_tmp4,1),1)];    %append the distance
        prop_tmp4(idx3,:) = [];         %all of the relavent vertices
        prop_tmp4 = prop_tmp4(uidx23,:);    %now unique
        %process for class 2(VGluT1&2)
        vert_tmp5 = data(ori).vertices;    %all ori vertices
        vert_tmp5(idx,:) = [];             %all relavent vertices
        vert_tmp5 = vert_tmp5(uidx2f1,:);
        e1 = vert_tmp5;
        prop_tmp5 = flatview2(data(ori).vert_prop,'max');   %all of the ori properties
        prop_tmp5 = [prop_tmp5 zeros(size(prop_tmp5,1),1)];    %append the distance
        prop_tmp5(idx,:) = [];         %all of the relavent vertices
        prop_tmp5 = prop_tmp5(uidx2f1,:);
    else        %not the origin
        %process for class 1(VGluT1)
        vert_tmp = tverts(:,:,i) ;    %all ori vertices
        vert_tmp(idx,:) = [];             %all relavent vertices
        vert_tmp = vert_tmp(uidx,:);    %unique
        if i==termi
            c2 = vert_tmp;           %store this for later use
        end
        %vert_tmp(isnan(vert_tmp(:,1)),:) = [];  %remove nan lines
        prop_tmp = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties
        prop_tmp(idx,:) = [];         %all of the relavent vertices
        prop_tmp = prop_tmp(uidx,:);    %unique
        %prop_tmp(isnan(prop_tmp(:,1)),:) = [];   %remove nan lines
        %process for class 2(VGluT21)
        vert_tmp2 = tverts(:,:,i);    %all ori vertices
        vert_tmp2(idx,:) = [];             %all relavent vertices
        vert_tmp2 = vert_tmp2(uidx21,:);    %unique
        if i==termi
            d2 = vert_tmp2;           %store this for later use
        end
        %vert_tmp2(isnan(vert_tmp2(:,1)),:) = [];  %remove nan lines
        prop_tmp2 = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties
        prop_tmp2(idx,:) = [];         %all of the relavent vertices
        prop_tmp2 = prop_tmp2(uidx21,:);    %unique
        %prop_tmp2(isnan(prop_tmp2(:,1)),:) = [];   %remove nan lines
        %process for class 1(VGluT3)
        vert_tmp3 = tverts(:,:,i);    %all ori vertices
        vert_tmp3(idx3,:) = [];             %all relavent vertices
        vert_tmp3 = vert_tmp3(uidx3,:);    %unique
        if i==termi
            c4 = vert_tmp3;           %store this for later use
        end
        %vert_tmp3(isnan(vert_tmp3(:,1)),:) = [];  %remove nan lines
        prop_tmp3 = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties
        prop_tmp3(idx3,:) = [];         %all of the relavent vertices
        prop_tmp3 = prop_tmp3(uidx3,:);    %unique
        %prop_tmp3(isnan(prop_tmp3(:,1)),:) = [];   %remove nan lines
        %process for class 2(VGluT23)
        vert_tmp4 = tverts(:,:,i);    %all ori vertices
        vert_tmp4(idx3,:) = [];             %all relavent vertices
        vert_tmp4 = vert_tmp4(uidx23,:);    %unique
        if i==termi
            d4 = vert_tmp4;           %store this for later use
        end
        %vert_tmp4(isnan(vert_tmp4(:,1)),:) = [];  %remove nan lines
        prop_tmp4 = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties
        prop_tmp4(idx3,:) = [];         %all of the relavent vertices
        prop_tmp4 = prop_tmp4(uidx23,:);    %unique
        %prop_tmp4(isnan(prop_tmp4(:,1)),:) = [];   %remove nan lines
        %process for class 2(VGluT1&2)
        vert_tmp5 = tverts(:,:,i);    %all ori vertices
        vert_tmp5(idx,:) = [];             %all relavent vertices
        vert_tmp5 = vert_tmp5(uidx2f1,:);
        if i==termi
            e2 = vert_tmp5;           %store this for later use
        end
        %vert_tmp5(isnan(vert_tmp5(:,1)),:) = [];  %remove nan lines
        prop_tmp5 = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties
        prop_tmp5(idx,:) = [];         %all of the relavent vertices
        prop_tmp5 = prop_tmp5(uidx2f1,:);
        %prop_tmp5(isnan(prop_tmp5(:,1)),:) = [];   %remove nan lines
    end
    %generate the dataset for the count numbers
    count = [count size(vert_tmp,1)];   %get the number of vertices for each channel
    count21 = [count21 size(vert_tmp2,1)];   %get the number of vertices for each channel
    count3 = [count3 size(vert_tmp3,1)];   %get the number of vertices for each channel
    count23 = [count23 size(vert_tmp4,1)];   %get the number of vertices for each channel
    count2 = [count2 size(vert_tmp5,1)];   %get the number of vertices for each channel
    %calculate the summary data
    %no outliers
    %Class1
    prop_cache = prop_tmp;   %we now want the prop to match the vert output, so work on a temporary var instead
    prop_cache(isnan(prop_cache(:,1)),:) = [];  %remove nan lines
    out = median(prop_cache(:,pidx))+std(prop_cache(:,pidx))*3;     %3 times the standard deviation should do it.
    [x,y] = find(prop_cache(:,pidx)>out);        %find the outliers.
    prop_cache(x,:) = [];             %remove the outliers
    sdata(1,:) = mean(prop_cache,1);
    sdata(2,:) = std(prop_cache,1);
    sdata(3,:) = size(prop_cache,1);
    sdata(4,:) = median(prop_cache,1);
    %Class21
    prop_cache2 = prop_tmp2;
    prop_cache2(isnan(prop_cache2(:,1)),:) = [];  %remove nan lines
    out = median(prop_cache2(:,pidx))+std(prop_cache2(:,2))*3;     %3 times the standard deviation should do it.
    [x,y] = find(prop_cache2(:,2)>out);        %find the outliers.
    prop_cache2(x,:) = [];             %remove the outliers
    sdata2(1,:) = mean(prop_cache2,1);
    sdata2(2,:) = std(prop_cache2,1);
    sdata2(3,:) = size(prop_cache2,1);
    sdata2(4,:) = median(prop_cache2,1);
    %Class3
    prop_cache3 = prop_tmp3;
    prop_cache3(isnan(prop_cache3(:,1)),:) = [];  %remove nan lines
    out = median(prop_cache3(:,pidx))+std(prop_cache3(:,pidx))*3;     %3 times the standard deviation should do it.
    [x,y] = find(prop_cache3(:,pidx)>out);        %find the outliers.
    prop_cache3(x,:) = [];             %remove the outliers
    sdata3(1,:) = mean(prop_cache3,1);
    sdata3(2,:) = std(prop_cache3,1);
    sdata3(3,:) = size(prop_cache3,1);
    sdata3(4,:) = median(prop_cache3,1);
    %Class23
    prop_cache4 = prop_tmp4;
    prop_cache4(isnan(prop_cache4(:,1)),:) = [];  %remove nan lines
    out = median(prop_cache4(:,pidx))+std(prop_cache4(:,pidx))*3;     %3 times the standard deviation should do it.
    [x,y] = find(prop_cache4(:,pidx)>out);        %find the outliers.
    prop_cache4(x,:) = [];             %remove the outliers
    sdata4(1,:) = mean(prop_cache4,1);
    sdata4(2,:) = std(prop_cache4,1);
    sdata4(3,:) = size(prop_cache4,1);
    sdata4(4,:) = median(prop_cache4,1);
    %Class1&2
    prop_cache5 = prop_tmp5;
    prop_cache5(isnan(prop_cache5(:,1)),:) = [];  %remove nan lines
    out = median(prop_cache5(:,pidx))+std(prop_cache5(:,pidx))*3;     %3 times the standard deviation should do it.
    [x,y] = find(prop_cache5(:,pidx)>out);        %find the outliers.
    prop_cache5(x,:) = [];             %remove the outliers
    sdata5(1,:) = mean(prop_cache5,1);
    sdata5(2,:) = std(prop_cache5,1);
    sdata5(3,:) = size(prop_cache5,1);
    sdata5(4,:) = median(prop_cache5,1);
    %save the ori data
    %Class1
    sav2csv(vert_tmp,['vert_',filename,'_',num2str(size(vert_tmp,1))],pathnames12);    %save the vertices
    sav2csv(prop_tmp,['prop_',filename],pathnames12);     %save the properties
    sav2csv(sdata,['sum_',filename],pathnames12);     %save the properties
    %Class21
    sav2csv(vert_tmp2,['vert_',filename,'_',num2str(size(vert_tmp2,1))],pathnames21);    %save the vertices
    sav2csv(prop_tmp2,['prop_',filename],pathnames21);     %save the properties
    sav2csv(sdata2,['sum_',filename],pathnames21);     %save the properties
    %Class1
    sav2csv(vert_tmp3,['vert_',filename,'_',num2str(size(vert_tmp3,1))],pathnames32);    %save the vertices
    sav2csv(prop_tmp3,['prop_',filename],pathnames32);     %save the properties
    sav2csv(sdata3,['sum_',filename],pathnames32);     %save the properties
    %Class21
    sav2csv(vert_tmp4,['vert_',filename,'_',num2str(size(vert_tmp4,1))],pathnames23);    %save the vertices
    sav2csv(prop_tmp4,['prop_',filename],pathnames23);     %save the properties
    sav2csv(sdata4,['sum_',filename],pathnames23);     %save the properties
    %Class1&2
    sav2csv(vert_tmp5,['vert_',filename,'_',num2str(size(vert_tmp5,1))],pathnames2);    %save the vertices
    sav2csv(prop_tmp5,['prop_',filename],pathnames2);     %save the properties
    sav2csv(sdata5,['sum_',filename],pathnames2);     %save the properties
    %store to ndata
    %Class1
    ndata(i).pivots = vert_tmp;
    ndata(i).props = prop_tmp;
    ndata(i).sum = sdata;
    %Class21
    ndata2(i).pivots = vert_tmp2;
    ndata2(i).props = prop_tmp2;
    ndata2(i).sum = sdata2;
    %Class3
    ndata3(i).pivots = vert_tmp3;
    ndata3(i).props = prop_tmp3;
    ndata3(i).sum = sdata3;
    %Class23
    ndata4(i).pivots = vert_tmp4;
    ndata4(i).props = prop_tmp4;
    ndata4(i).sum = sdata4;
    %Class1&2
    ndata5(i).pivots = vert_tmp5;
    ndata5(i).props = prop_tmp5;
    ndata5(i).sum = sdata5;
end
%now finish saving the count data
data_tmp = dataset(count','ObsNames',celllabels','VarNames',{'count'});
sav2csv(data_tmp,'count_summary.csv',pathnames12);
%#2
data_tmp = dataset(count2','ObsNames',celllabels','VarNames',{'count'});
sav2csv(data_tmp,'count_summary2.csv',pathnames2);
%#3
data_tmp = dataset(count3','ObsNames',celllabels','VarNames',{'count'});
sav2csv(data_tmp,'count_summary3.csv',pathnames32);
%#21
data_tmp = dataset(count21','ObsNames',celllabels','VarNames',{'count'});
sav2csv(data_tmp,'count_summary21.csv',pathnames21);
%#23
data_tmp = dataset(count23','ObsNames',celllabels','VarNames',{'count'});
sav2csv(data_tmp,'count_summary23.csv',pathnames23);
close(h);   %close progress bar

% %now get the rotated vertices
% t_out = [];     %initiate
% t_out2 = [];
% t_out3 = [];
% t_out4 = [];
% t_out5 = [];
% h1 = waitbar(0,'Rotating Vertices of: ');    %initialize progress bar
% matlabpool      %lets go massive
% for j = 1:size(filenames,2)
%     if j~=ori && j~=termi
%         %process filename
%         strmask = isspace(filenames{j});
%         spcloc = find(strmask==1);
%         filename = strtrim(filenames{j}(min(spcloc):max(spcloc)));
%         waitbar(j/size(filenames,2),h1,['Rotating Vertices of: ' filename]);   %update progress
%         third = alldata(ori).all_termi(:,:,j);     %get the third point
%         %Class1
%         if ~isempty(uidx)
%             [chan,t_tmp] = syn_align_loco(c1,c2,third);
%             [chan1] = flat_verts(chan);
%             sav2csv(chan,['3Dvert_',filename],pathnames12);
%             sav2csv(chan1,['flat_',filename],pathnames12);
%             t_out = vertcat(t_out,t_tmp);
%             %save to ndata
%             ndata(j).rotpivots = chan;
%             ndata(j).flatpivots = chan1;
%         end
%         %Class21
%         if ~isempty(uidx2)
%             [chan,t_tmp] = syn_align_loco(d1,d2,third);
%             [chan1] = flat_verts(chan);
%             sav2csv(chan,['3Dvert_',filename],pathnames21);
%             sav2csv(chan1,['flat_',filename],pathnames21);
%             t_out2 = vertcat(t_out2,t_tmp);
%             %save to ndata
%             ndata2(j).rotpivots = chan;
%             ndata2(j).flatpivots = chan1;
%         end
%         %Class32
%         if ~isempty(uidx3)
%             [chan,t_tmp] = syn_align_loco(c3,c4,third);
%             [chan1] = flat_verts(chan);
%             sav2csv(chan,['3Dvert_',filename],pathnames32);
%             sav2csv(chan1,['flat_',filename],pathnames32);
%             t_out3 = vertcat(t_out2,t_tmp);
%             %save to ndata
%             ndata3(j).rotpivots = chan;
%             ndata3(j).flatpivots = chan1;
%         end
%         %Class23
%         if ~isempty(uidx23)
%             [chan,t_tmp] = syn_align_loco(d3,d4,third);
%             [chan1] = flat_verts(chan);
%             sav2csv(chan,['3Dvert_',filename],pathnames23);
%             sav2csv(chan1,['flat_',filename],pathnames23);
%             t_out4 = vertcat(t_out2,t_tmp);
%             %save to ndata
%             ndata4(j).rotpivots = chan;
%             ndata4(j).flatpivots = chan1;
%         end
%         %Class1&2
%         if ~isempty(uidx2f1)
%             [chan,t_tmp] = syn_align_loco(e1,e2,third);
%             [chan1] = flat_verts(chan);
%             sav2csv(chan,['3Dvert_',filename],pathnames2);
%             sav2csv(chan1,['flat_',filename],pathnames2);
%             t_out5 = vertcat(t_out2,t_tmp);
%             %save to ndata
%             ndata5(j).rotpivots = chan;
%             ndata5(j).flatpivots = chan1;
%         end
%     end
% end
% close(h1);
% matlabpool close
% 
% %save terminal output
% %[t_out] = rmv_duplicate(t_out,[1 2 3]);     %remove duplicates...does not apply here, but remember collapse!
% %Class1
% t_out = unique(t_out,'rows');
% ndata(1).termipivots = t_out;
% sav2csv(t_out,'rotated_termini',pathnames12);
% %Class21
% t_out2 = unique(t_out2,'rows');
% ndata2(1).termipivots = t_out2;
% sav2csv(t_out2,'rotated_termini',pathnames21);
% %Class32
% t_out3 = unique(t_out3,'rows');
% ndata3(1).termipivots = t_out3;
% sav2csv(t_out3,'rotated_termini',pathnames32);
% %Class21
% t_out4 = unique(t_out4,'rows');
% ndata4(1).termipivots = t_out4;
% sav2csv(t_out4,'rotated_termini',pathnames23);
% %Class1&2
% t_out5 = unique(t_out5,'rows');
% ndata5(1).termipivots = t_out5;
% sav2csv(t_out5,'rotated_termini',pathnames2);
%localization for macs
if ispc
    slash = '\';        %Windows directory marker
else
    slash = '/';        %Mac directory marker
end
%Class1
save([pathnames12,slash,'ndata.mat'],'ndata');      %save ndata as well
%Class21
save([pathnames21,slash,'ndata2.mat'],'ndata2');      %save ndata as well
%Class32
save([pathnames32,slash,'ndata3.mat'],'ndata3');      %save ndata as well
%Class23
save([pathnames23,slash,'ndata4.mat'],'ndata4');      %save ndata as well
%Class1&2
save([pathnames2,slash,'ndata5.mat'],'ndata5');      %save ndata as well

%--------------------------------------------------------------------------
function [chan,t_out,o_out,flprot_idx] = syn_align_loco(ori,termi,third)
%Translate all the points first
o_tmp = zeros(size(ori,1),3); %translate ori to 0,0,0.  This is assuming that all vertices are positive, which for an image should be true.
t_tmp = termi(:,1:3)-ori(:,1:3);    %translate termi
%translate third
parfor j = 1:size(ori,1)
    curr_cell = third{ori(j,4)};    %find the current cell in the third channel.  Use the ordinals to pick the cell
    c_tmp{j,1} = curr_cell(:,1:3)-repmat(ori(j,1:3),size(curr_cell,1),1);       %translate channels
end

%fix one last thing, rotate all negative x's to positive, 180 flip,
%because we are enforcing directionality
flpx_idx = t_tmp(:,1)<0;   %create the flip index: 1 will flip and 0 will not
flpx_mtrx = ones(size(t_tmp,1),1);     %create flip matrix for x
flpx_mtrx(flpx_idx,:) = -1;
%modify termial point
t_tmp(:,1) = t_tmp(:,1).*flpx_mtrx;
t_tmp(:,2) = t_tmp(:,2).*flpx_mtrx;     %y is flipped as well for a 180 turn
%modify channel points (third points)
parfor m = 1:size(c_tmp,1)
    c_tmp{m,1}(:,1) = c_tmp{m,1}(:,1)*flpx_mtrx(m,1);      %rotate 180deg x
    c_tmp{m,1}(:,2) = c_tmp{m,1}(:,2)*flpx_mtrx(m,1);      %rotate 180deg y
end

%Now calculate the angle of rotation on the x axis
%calculate vector 1, ori - termi  rotated
v1 = horzcat(hypot(t_tmp(:,1),t_tmp(:,2)),zeros(size(t_tmp,1),1));   %rotating the syn axis to x 0, everything will be aligned to the y axis
v2 = t_tmp(:,[1 2]);      %the origial 
parfor m = 1:size(v1,1)    %calculate the dot product for each pair of vectors
    x_rot(m,1) = dot(v2(m,:),v1(m,:));     %calculate the dot product, which gives us the cos of the angle
end
%x_rot = acos(x_rot./(hypot(v1(:,1),v1(:,2)).*hypot(v2(:,1),v2(:,2)))).*180/pi;        %calculate the angles in degress.
x_rot = acosd(single(x_rot)./single(hypot(v1(:,1),v1(:,2)).*hypot(v2(:,1),v2(:,2))));        %calculate the angles in degress.
%find the clockwise rotations
neg_idx = ones(size(t_tmp,1),1);           %start the index
neg_idx(t_tmp(:,2)>0) = -1;        %clockwise rotation is -degree angle of rotation
%modify rotation angles
x_rot = x_rot.*neg_idx;         %clockwise and counter clockwise set.
%rotate the base vector
parfor m = 1:size(x_rot,1)
    x_tmp(m,:) = ([cosd(x_rot(m,1)),-sind(x_rot(m,1));sind(x_rot(m,1)),cosd(x_rot(m,1))]*[t_tmp(m,1);t_tmp(m,2)])';
end
t_tmp(:,1) = x_tmp(:,1);
%calculte the angle of roation on the z axis
v3 = horzcat(hypot(t_tmp(:,1),t_tmp(:,3)),zeros(size(t_tmp,1),1));   %rotating the syn axis to z 0
v4 = t_tmp(:,[1 3]);      %the origial vector
parfor n = 1:size(v1,1)        %Dot product per pair of vectors
    z_rot(n,1) = dot(v4(n,:),v3(n,:));     %calculate the dot product, which gives us the cos of the angle
end
%z_rot = acos(z_rot./(hypot(v3(:,1),v3(:,2)).*hypot(v4(:,1),v4(:,2)))).*180/pi;        %calculate the angles in degress.
z_rot = acosd(single(z_rot)./single(hypot(v3(:,1),v3(:,2)).*hypot(v4(:,1),v4(:,2))));        %calculate the angles in degress.
%find the clockwise rotations
neg_idx = ones(size(t_tmp,1),1);           %start the index
neg_idx(t_tmp(:,3)>0) = -1;        %clockwise rotation is -degree angle of rotation
%modify rotation angles
z_rot = z_rot.*neg_idx;         %clockwise and counter clockwise set.

%now rotate the third points
chan = [];      %initialize
%h = waitbar(0,'Rotating Vector: 0');    %initialize progress bar.
parfor k = 1:size(c_tmp,1)
    %waitbar(k/size(c_tmp,1),h,['Rotating Vector: ' num2str(k)]);   %update progress
    curr_cell = c_tmp{k,1};    %find the current cell in the third channel. 
    for l = 1:size(curr_cell,1)     %go through the vertices
        rotx_tmp = [cosd(x_rot(k,1)),-sind(x_rot(k,1));sind(x_rot(k,1)),cosd(x_rot(k,1))]*curr_cell(l,[1 2])';    %rotation in x plane
        rotz_tmp = [cosd(z_rot(k,1)),-sind(z_rot(k,1));sind(z_rot(k,1)),cosd(z_rot(k,1))]*[rotx_tmp(1) curr_cell(l,3)]';    %more acurate for x, but not z???
        chan_tmp(l,:) = [rotz_tmp(1) rotx_tmp(2) rotz_tmp(2)];        %store new rotated vertex.
    end
    chan_tmp(isnan(chan_tmp)) = 0;      %Nan is 0
    chan = vertcat(chan,chan_tmp);      %create the rotated third channel, we no longer need the structure of c_tmp or ori or termi, unbound.
    chan_tmp = [];
end
%close(h);   %close progress bar

%output termi and ori
if size(termi,2)==3     %no extra data, just the vertex
    t_out = [hypot(t_tmp(:,1),hypot(t_tmp(:,2),t_tmp(:,3))),zeros(size(t_tmp,1),2)];
    o_out = o_tmp;
else                    %extra data, concatenate into the matrix
    t_out = horzcat([t_tmp(:,1),zeros(size(t_tmp,1),1),t_tmp(:,3)],termi(:,end-(size(termi,2)-3):end));
    o_out = horzcat(o_tmp,ori(:,end-(size(ori,2)-3):end));
end
%output flprot_idx
flprot_idx = [flpx_idx x_rot z_rot];